---
obsidianUIMode: preview
---

This section offers abbreviated guidelines for running "theater of the mind" combat — no maps or miniatures, making use only of narrative and your players' imaginations. Share these guidelines with your players so that everyone has a common understanding of how this style of playing out combat works at the table.

## Core Principles

Round-by-round combat played in the theater-of-the-mind style is built around three core principles:

* The GM describes the situation.
* Players describe their characters' intent.
* The GM helps the players achieve that intent and adjudicates how the situation unfolds as a result.

## Common Understandings

A GM running a theater-of-the-mind game should keep the following points in mind:

* Build theater-of-the-mind combat around the following ideals: The GM and the players are working together to share a story of high action and adventure. They are not opponents.
* The GM and players do not hide their intentions during combat.
* Players and GMs assume that the characters and their enemies all move cautiously, avoiding opportunity attacks whenever possible.
* The GM identifies when a character is taking a risk, such as provoking an opportunity attack, before the player chooses the character's action.

## Player Advice

Players in a theater-of-the-mind game should keep the following points in mind:

* Describe your intent. Tell the GM what you want your character to do in the story that the combat encounter is building. Avoid a back-and-forth series of tactical questions.
* Tell the GM what special features your character has that you want to highlight. If you have crunchy tactical abilities you want to use, describe how you want them to work for the situation. For example: "I want to stay close to the cleric so I can use my Protection Fighting Style, but I'll keep 10 feet away from the orcs so I can use my Polearm Mastery feat to hit them on their way in."
* Describe specifically what you want to do. "I want to stay within the paladin's aura but still attack the hobgoblin ravager."
* Look for fun ways to use the environment described by the GM.
* Worry less about the mechanical details of the game and more on the high action and adventure of the story. One good way to do that is to imagine combat as a high-action battle in one of your favorite movies.

## GM Advice

A GM running a theater-of-the-mind game should keep the following points in mind:

* Work with the players, not against them. Err in favor of the characters as you help the players achieve their intent.
* Each turn, describe the situation surrounding the acting character.
* Adjudicate the number of targets in an area attack based on the situation, the assumed positions of the combatants, and the size of the area.
* Use evocative in-world narration to describe the characters, the monsters, the action, and the high adventure of the story as it plays out.
* Make bargains and deals with the players. "You can hit three orcs with *fireball*, or you can hit five orcs if one of your companions is willing to be hit as well."
* Describe the distances between combatants in feet to help players recognize what they can and can't do. Default to 25 feet if you don't really know.
* Run simpler encounters with useful environmental features, such as flipped tables, cracked stalagmites, cliff edges, bottomless pits, roaring fires, and hanging chandeliers.
* Ask the players to identify monsters by describing interesting physical characteristics.
* Give the players opportunities to show off their characters' skills and abilities.
* Some players can't visualize combat scenes in their head, a condition known as aphantasia. For these players, consider providing a quick sketch or other visual.

## One Tool of Many

Add theater of the mind to your collection of ways to run combat, including abstract maps, zone-based combat (described later in this document), gridded combat, or 3D terrain. Choose the right style of combat for the pace and complexity of the scene. Keep each approach as a tool in your GM's toolbox to help you share exciting tales of action and high adventure.
